import React, {Component} from 'react';
import PropTypes from 'prop-types';
import gql from 'graphql-tag';
import {graphql, compose} from "react-apollo";
import BlinkDot from "../Loading/BlinkDot";

class DocumentsBreadcrumb extends Component {

    render() {
        const {data} = this.props;
        const {loading, documento} = data;
	console.log(this.props)

        if(loading) {
            return (<span className="text-info" style={{fontWeight: "normal", fontSize: "1.3rem"}}>
                <BlinkDot/>
                <BlinkDot/>
                <BlinkDot/>
            </span>)
        }

        return (<span>
            {documento.nomeFile}
        </span>);
    }
}

export default compose(
    graphql(gql`
        query ($id: Long) {
            documento(id: $id) {
                id
		nomeFile
            }
        }
    `, {
        options:({id}) => {return{variables: {id: id}}},
    }),
)(DocumentsBreadcrumb);

DocumentsBreadcrumb.defaultProps = {};

DocumentsBreadcrumb.propTypes = {};
